#!/bin/sh -xe
# options: writethrough, writeback, directsync, none, unsafe
# WARNING: When using unsafe make sure you have snapshot mode enabled

QEMU="x86_64-softmmu/qemu-system-x86_64"
DISK_CACHE="writethrough"
CORES=4
MEMORY="-m 8G"
IMG="../../cosim.qcow2"

UNTIMED="-enable-kvm  -cpu host -smp cores=$CORES"
DRIVE="-drive file=$IMG,cache=$DISK_CACHE"
FPGA_PCIE="-device accelerator-pcie"

#OPTS="-snapshot"
OPTS=""

sudo -E $QEMU $MEMORY $UNTIMED $OPTS $DRIVE $FPGA_PCIE

